﻿
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class CompetencePart : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.CompetencePart, BO.CompetencePart>
    {

        internal CompetencePart(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal CompetencePart(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.CompetencePart.DBD) { }

        internal List<BO.CompetencePart> Restore(BO.CompetencePart.Search Search)
              {
                return InternalRestoreList((int)DBD.CompetencePart.Commands.RestoreBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["CompetenceID"].Value = Search.CompetenceID;
                    Command["IsActive"].Value = Search.IsActive;
                    Command["IsValid"].Value = Search.IsValid;
                });
              }

        internal int Count(BO.CompetencePart.Search Search)
        {
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.CompetencePart.Commands.CountBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["CompetenceID"].Value = Search.CompetenceID;
                    Command["IsActive"].Value = Search.IsActive;
                    Command["IsValid"].Value = Search.IsValid;
                });

            if (_command != null)
            {
                return Convert.ToInt32(_command["Result"].Value);
            }
            return 0;
        }

        internal BO.CompetencePart Restore(BO.Student Student)
        {
            return InternalRestoreOne((int)DBD.CompetencePart.Commands.RestoreByStudent,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["StudentID"].Value = Student.ID;
            });
        }
    }
}
